/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.configs.ClientConfigs;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.network.NetworkHandler;
import com.ordana.immersive_weathering.network.SendCustomParticlesPacket;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5689;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

public class LeavesGrowth
extends BuiltinBlockGrowth {
    public LeavesGrowth(String name, @Nullable class_6885<class_2248> owners, List<TickSource> sources, float chance) {
        super(name, owners, sources, chance);
    }

    @Override
    public void tryGrowing(class_2338 pos, class_2680 state, class_3218 level, Supplier<class_6880<class_1959>> biome) {
        class_2248 leafPile;
        if (this.growthChance != 1.0f && !(level.field_9229.method_43057() < this.growthChance)) {
            return;
        }
        class_5819 random = level.field_9229;
        if ((!state.method_28498((class_2769)class_2397.field_11200) || !((Boolean)state.method_11654((class_2769)class_2397.field_11200)).booleanValue()) && random.method_43057() < (float)CommonConfigs.LEAF_PILES_REACH.get().intValue() && (leafPile = (class_2248)WeatheringHelper.getFallenLeafPile(state).orElse(null)) != null && level.method_8320(pos.method_10074()).method_26215()) {
            if (random.method_43056() && WeatheringHelper.isIciclePos(pos) && ((class_1959)level.method_23753(pos).comp_349()).method_33599(pos)) {
                level.method_8652(pos.method_10074(), (class_2680)ModBlocks.ICICLE.get().method_9564().method_11657((class_2769)class_5689.field_28050, (Comparable)class_2350.field_11033), 2);
            }
            if (!PlatformHelper.isAreaLoaded((class_4538)level, (class_2338)pos, (int)2)) {
                return;
            }
            class_2338 targetPos = level.method_8598(class_2902.class_2903.field_13203, pos);
            int maxFallenLeavesReach = CommonConfigs.LEAF_PILES_REACH.get();
            int maxPileHeight = CommonConfigs.LEAF_PILE_MAX_HEIGHT.get();
            int dist = pos.method_10264() - targetPos.method_10264();
            if (dist < 0) {
                class_2680 selected;
                targetPos = pos;
                do {
                    targetPos = targetPos.method_10074();
                    dist = pos.method_10264() - targetPos.method_10264();
                } while ((selected = level.method_8320(targetPos)).method_26207().method_15800() && selected.method_26227().method_15769() && dist < maxFallenLeavesReach);
                targetPos = targetPos.method_10084();
            }
            if (dist < maxFallenLeavesReach) {
                this.tryPlacingAt(level, leafPile, targetPos, maxPileHeight);
            }
        }
    }

    private void tryPlacingAt(class_3218 level, class_2248 leafPile, class_2338 targetPos, int maxPileHeight) {
        class_2680 replaceState = level.method_8320(targetPos);
        class_2680 groundState = level.method_8320(targetPos.method_10074());
        boolean isOnLeaf = replaceState.method_26204() instanceof LeafPileBlock;
        boolean waterBelow = groundState.method_27852(class_2246.field_10382) && groundState.method_26227().method_15771();
        int pileHeight = 1;
        if (isOnLeaf && ((pileHeight = ((Integer)replaceState.method_11654((class_2769)LeafPileBlock.LAYERS)).intValue()) == 0 || pileHeight >= maxPileHeight)) {
            return;
        }
        class_2680 baseLeaf = (class_2680)leafPile.method_9564().method_11657((class_2769)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(waterBelow ? 0 : 1));
        if (isOnLeaf || replaceState.method_26207().method_15800() && baseLeaf.method_26184((class_4538)level, targetPos) && !WeatheringHelper.hasEnoughBlocksAround(targetPos, 2, 1, 2, (class_1937)level, b -> b.method_26204() instanceof LeafPileBlock, 5)) {
            if (waterBelow) {
                level.method_8652(targetPos, baseLeaf, 2);
            } else {
                if (isOnLeaf) {
                    int original = pileHeight;
                    boolean hasLog = false;
                    class_2680[] neighbors = new class_2680[4];
                    for (class_2350 direction : class_2350.class_2353.field_11062) {
                        neighbors[direction.method_10161()] = level.method_8320(targetPos.method_10093(direction));
                    }
                    for (class_2680 neighbor : neighbors) {
                        if (!WeatheringHelper.isLog(neighbor)) continue;
                        hasLog = true;
                        break;
                    }
                    for (class_2680 neighbor : neighbors) {
                        int i;
                        if (!(neighbor.method_26204() instanceof LeafPileBlock)) continue;
                        int n = i = hasLog ? maxPileHeight : Math.min((Integer)neighbor.method_11654((class_2769)LeafPileBlock.LAYERS) - 1, maxPileHeight);
                        if (i <= pileHeight) continue;
                        pileHeight = Math.min(pileHeight + 1, i);
                        break;
                    }
                    if (pileHeight == original) {
                        return;
                    }
                }
                level.method_8652(targetPos, (class_2680)baseLeaf.method_11657((class_2769)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(pileHeight)), 2);
            }
        }
    }

    public static void spawnFallingLeavesParticle(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (!(state.method_26204() instanceof class_2397)) {
            return;
        }
        if (ClientConfigs.FALLING_LEAF_PARTICLES.get().booleanValue() && !((Boolean)state.method_11654((class_2769)class_2397.field_11200)).booleanValue()) {
            class_2400 leafParticle = WeatheringHelper.getFallenLeafParticle(state).orElse(null);
            if (leafParticle == null) {
                return;
            }
            int color = class_310.method_1551().method_1505().method_1697(state, (class_1920)level, pos, 0);
            class_2338 blockPos = pos.method_10074();
            class_2680 blockState = level.method_8320(blockPos);
            float rate = 0.08f;
            if (!blockState.method_26225() || !blockState.method_26234((class_1922)level, blockPos)) {
                if (level.method_8419()) {
                    rate = 0.4f;
                }
                if (random.method_43057() < rate) {
                    double d = (double)pos.method_10263() + random.method_43058();
                    double e = (double)pos.method_10264() - 0.05;
                    double f = (double)pos.method_10260() + random.method_43058();
                    level.method_8406((class_2394)leafParticle, d, e, f, 0.0, (double)color, 0.0);
                }
            }
        }
    }

    public static void decayLeavesPile(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        class_2338 downPos;
        class_2680 downState;
        if (!(state.method_26204() instanceof class_2397)) {
            ImmersiveWeathering.LOGGER.error("Some mod tried to call leaves random tick without passing a leaf block blockstate as expected. This should be fixed on their end. Given blockstate : {}", (Object)state);
            return;
        }
        if (CommonConfigs.LEAF_PILES_FROM_DECAY_CHANCE.get() > (double)level.field_9229.method_43057()) {
            class_2248 leafPile = WeatheringHelper.getFallenLeafPile(state).orElse(null);
            if (leafPile == null) {
                return;
            }
            class_2680 baseLeaf = leafPile.method_9564();
            level.method_8652(pos, (class_2680)baseLeaf.method_11657((class_2769)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(class_3532.method_32751((class_5819)level.field_9229, (int)1, (int)5))), 2);
        }
        if (!(downState = level.method_8320(downPos = pos.method_10074())).method_26225() || !downState.method_26206((class_1922)level, downPos, class_2350.field_11036)) {
            NetworkHandler.CHANNEL.sendToAllClientPlayersInRange((class_1937)level, pos, 32.0, (Message)new SendCustomParticlesPacket(SendCustomParticlesPacket.EventType.DECAY_LEAVES, pos, class_2248.method_9507((class_2680)state)));
        }
    }
}

